/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.session;

import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.businessconnector.ehboxV2.session.EhealthBoxServiceV2;
import be.ehealth.businessconnector.ehboxV2.session.impl.EhealthBoxServiceV2Impl;
import be.ehealth.businessconnector.ehboxV2.validator.EhboxReplyValidator;
import be.ehealth.businessconnector.ehboxV2.validator.impl.EhboxReplyValidatorImpl;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.validator.impl.SAMLSessionValidator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceFactory {
    private static EhboxReplyValidator replyValidator = new EhboxReplyValidatorImpl();
    private static SessionValidator sessionValidator = new SAMLSessionValidator();
    private static final Logger LOG = LoggerFactory.getLogger(ServiceFactory.class);
    private static Map<Class<?>, Object> serviceCache = new HashMap();

    private ServiceFactory() {
    }

    public static EhealthBoxServiceV2 getEhealthBoxServiceV2() throws TechnicalConnectorException, EhboxBusinessConnectorException {
        return ServiceFactory.getService(EhealthBoxServiceV2Impl.class);
    }

    private static <T> T getService(Class<T> clazz) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        if (!serviceCache.containsKey(clazz)) {
            ServiceFactory.createService(clazz);
        }
        return (T)serviceCache.get(clazz);
    }

    private static <T> void createService(Class<T> clazz) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        LOG.debug("Creating new Service for :" + clazz.getCanonicalName());
        if (clazz.equals(EhealthBoxServiceV2Impl.class)) {
            serviceCache.put(clazz, new EhealthBoxServiceV2Impl(ServiceFactory.getSessionValidator(), ServiceFactory.getReplyValidator()));
        }
    }

    private static synchronized SessionValidator getSessionValidator() {
        if (sessionValidator == null) {
            sessionValidator = new SAMLSessionValidator();
        }
        return sessionValidator;
    }

    private static synchronized EhboxReplyValidator getReplyValidator() {
        if (replyValidator == null) {
            replyValidator = new EhboxReplyValidatorImpl();
        }
        return replyValidator;
    }

    public static void flushCache() {
        LOG.debug("Flushing cache, clearing all services and deleting personal and system Crypto.");
        serviceCache.clear();
        replyValidator = null;
        sessionValidator = null;
    }
}

