/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.builders.impl;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.domain.Message;
import be.ehealth.businessconnector.ehbox.api.domain.NewsMessage;
import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.ehboxV2.builders.ConsultationMessageBuilder;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.exception.UnsealConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetFullMessageResponse;
import be.fgov.ehealth.ehbox.core.v2.AnnexType;
import be.fgov.ehealth.ehbox.core.v2.ConsultContentSpecificationType;
import be.fgov.ehealth.ehbox.core.v2.CustomMetaType;
import be.fgov.ehealth.ehbox.core.v2.DestinationContext;
import be.fgov.ehealth.ehbox.core.v2.EhboxIdentifierType;
import be.fgov.ehealth.ehbox.core.v2.SenderType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsultationMessageBuilderImpl
implements ConsultationMessageBuilder {
    private static final int DEFAULT_ARRAY_EXT = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(ConsultationMessageBuilderImpl.class);
    private static final String BASE64_VALIDATOR_REGEX = "^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$";

    @Deprecated
    public ConsultationMessageBuilderImpl(Crypto cryptoSystem) {
    }

    public ConsultationMessageBuilderImpl() {
    }

    @Override
    public final Message<be.fgov.ehealth.ehbox.consultation.protocol.v2.Message> buildMessage(be.fgov.ehealth.ehbox.consultation.protocol.v2.Message response) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        boolean isDocument = false;
        DocumentMessage message = null;
        String contentType = response.getContentInfo().getContentType();
        if ("DOCUMENT".equals(contentType)) {
            message = new DocumentMessage();
            isDocument = true;
        } else if ("NEWS".equals(contentType)) {
            message = new NewsMessage();
        } else {
            throw new UnsupportedOperationException("unknown contentType " + contentType + " , cannot handle this messageType");
        }
        message.setOriginal((Object)response);
        message.setId(response.getMessageId());
        message.setPublicationId(null);
        if (response.getContentSpecification() != null) {
            message.setImportant(response.getContentSpecification().isIsImportant());
            message.setEncrypted(response.getContentSpecification().isIsEncrypted());
        }
        if (response.getContentInfo() != null) {
            message.setHasAnnex(response.getContentInfo().isHasAnnex());
            message.setHasFreeInformations(response.getContentInfo().isHasFreeInformations());
        }
        if (response.getCustomMetas() != null) {
            List metas = response.getCustomMetas();
            for (CustomMetaType meta : metas) {
                message.getCustomMetas().put(meta.getKey(), meta.getValue());
            }
        }
        if (response.getMessageInfo() != null) {
            message.setExpirationDateTime(response.getMessageInfo().getExpirationDate());
            message.setPublicationDateTime(response.getMessageInfo().getPublicationDate());
            message.setSize(response.getMessageInfo().getSize());
        }
        if (response.getDestination() != null) {
            Addressee destination = this.buildAddressee(response.getDestination());
            message.getDestinations().add(destination);
        }
        this.processMandatee(response.getMandatee(), (Message<?>)message);
        this.processSender(response.getSender(), response.getContentSpecification(), (Message<?>)message);
        this.processContent(response, isDocument, (Message<be.fgov.ehealth.ehbox.consultation.protocol.v2.Message>)message);
        return message;
    }

    private void processContent(be.fgov.ehealth.ehbox.consultation.protocol.v2.Message response, boolean isDocument, Message<be.fgov.ehealth.ehbox.consultation.protocol.v2.Message> message) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        if (isDocument) {
            DocumentMessage documentMessage = (DocumentMessage)message;
            Document document = new Document();
            document.setTitle(response.getContentInfo().getTitle());
            documentMessage.setDocument(document);
            byte[] decodedInss = this.base64decoding(response.getContentInfo().getEncryptableINSSPatient(), documentMessage.isEncrypted());
            if (decodedInss != null) {
                try {
                    documentMessage.setPatientInss(new String(decodedInss, Charset.UTF_8.getName()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CHARACTER_ENCODING_NOTSUPPORTED, (Throwable)e, new Object[0]);
                }
            }
        } else {
            NewsMessage newsMessage = (NewsMessage)message;
            Document document = new Document();
            document.setTitle(response.getContentInfo().getTitle());
            newsMessage.setDocument(document);
        }
    }

    @Override
    public final Message<GetFullMessageResponse> buildFullMessage(GetFullMessageResponse response) throws EhboxBusinessConnectorException, TechnicalConnectorException {
        DocumentMessage message = null;
        boolean isDocument = false;
        if (response.getMessage().getContentContext().getContent().getDocument() != null) {
            message = new DocumentMessage();
            isDocument = true;
        } else {
            message = new NewsMessage();
        }
        message.setOriginal((Object)response);
        this.processMessageInfo(response, (Message<?>)message);
        this.processMandatee(response.getMandatee(), (Message<?>)message);
        this.processSender(response.getSender(), null, (Message<?>)message);
        this.processDestinationContext(response.getMessage().getDestinationContexts(), (Message<?>)message);
        this.processMessage(response, (Message<?>)message);
        if (isDocument) {
            try {
                this.processDocument(response, (Message<?>)message);
            }
            catch (UnsupportedEncodingException e) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CHARACTER_ENCODING_NOTSUPPORTED, (Throwable)e, new Object[0]);
            }
        } else {
            this.processNews(response, (Message<?>)message);
        }
        return message;
    }

    private void processNews(GetFullMessageResponse response, Message<?> message) throws EhboxBusinessConnectorException, TechnicalConnectorException {
        NewsMessage newsMessage = (NewsMessage)message;
        newsMessage.getDocument().setTitle(response.getMessage().getContentContext().getContent().getNews().getTitle());
        DataHandler responseHandler = null;
        if (response.getMessage().getContentContext().getContent().getNews().getEncryptableBinaryContent() != null) {
            responseHandler = response.getMessage().getContentContext().getContent().getNews().getEncryptableBinaryContent();
        } else if (response.getMessage().getContentContext().getContent().getNews().getEncryptableTextContent() != null) {
            responseHandler = response.getMessage().getContentContext().getContent().getNews().getEncryptableTextContent();
        }
        if (responseHandler != null) {
            newsMessage.getDocument().setContent(this.base64decoding(responseHandler, newsMessage.isEncrypted()));
        }
    }

    private void processDocument(GetFullMessageResponse response, Message<?> message) throws TechnicalConnectorException, EhboxBusinessConnectorException, UnsupportedEncodingException {
        DocumentMessage documentMessage = (DocumentMessage)message;
        this.processINSSPatient(response, documentMessage);
        this.processFreeText(response, documentMessage);
        this.processMainDocument(response, documentMessage);
        for (AnnexType annexType : response.getMessage().getContentContext().getContent().getAnnices()) {
            this.processAnnex(documentMessage, annexType);
        }
    }

    private void processMessage(GetFullMessageResponse response, Message<?> message) {
        if (response.getMessage() != null) {
            message.setId(response.getMessage().getMessageId());
            message.setPublicationId(response.getMessage().getPublicationId());
            if (response.getMessage().getContentContext() != null) {
                for (CustomMetaType meta : response.getMessage().getContentContext().getCustomMetas()) {
                    message.getCustomMetas().put(meta.getKey(), meta.getValue());
                }
                if (response.getMessage().getContentContext().getContentSpecification() != null) {
                    message.setEncrypted(response.getMessage().getContentContext().getContentSpecification().isIsEncrypted());
                    message.setImportant(response.getMessage().getContentContext().getContentSpecification().isIsImportant());
                    if (message.getSender() != null) {
                        message.getSender().setApplicationId(response.getMessage().getContentContext().getContentSpecification().getApplicationName());
                    }
                }
            }
        }
    }

    private void processMessageInfo(GetFullMessageResponse response, Message<?> message) {
        if (response.getMessageInfo() != null) {
            message.setExpirationDateTime(response.getMessageInfo().getExpirationDate());
            message.setPublicationDateTime(response.getMessageInfo().getPublicationDate());
            message.setSize(response.getMessageInfo().getSize());
        }
    }

    private void processSender(SenderType inSender, ConsultContentSpecificationType contentspec, Message<?> message) {
        if (inSender != null) {
            Addressee addressee = this.buildAddressee(inSender);
            if (contentspec != null) {
                addressee.setApplicationId(contentspec.getApplicationName());
            }
            message.setSender(addressee);
        }
    }

    private void processMandatee(SenderType inMandatee, Message<?> message) {
        if (inMandatee != null) {
            Addressee mandatee = this.buildAddressee(inMandatee);
            List destinations = message.getDestinations();
            destinations.add(mandatee);
            message.setDestinations(destinations);
        }
    }

    private void processDestinationContext(List<DestinationContext> destinationList, Message<?> message) {
        for (DestinationContext destinationContext : destinationList) {
            IdentifierType identityType = IdentifierType.lookup((String)destinationContext.getType(), (String)destinationContext.getSubType(), (int)49);
            Addressee destination = new Addressee(identityType);
            destination.setId(destinationContext.getId());
            if (destinationContext.getUser() != null) {
                destination.setFirstName(destinationContext.getUser().getFirstName());
                destination.setLastName(destinationContext.getUser().getLastName());
            }
            destination.setQuality(destinationContext.getQuality());
            message.getDestinations().add(destination);
        }
    }

    private void processAnnex(DocumentMessage<?> documentMessage, AnnexType annexType) throws TechnicalConnectorException, EhboxBusinessConnectorException, UnsupportedEncodingException {
        Document annex = new Document();
        annex.setFilename(annexType.getDownloadFileName());
        annex.setMimeType(annexType.getMimeType());
        byte[] annexTitle = this.base64decoding(annexType.getEncryptableTitle(), documentMessage.isEncrypted());
        if (annexTitle != null) {
            annex.setTitle(new String(annexTitle, Charset.UTF_8.getName()));
        }
        DataHandler annexHandler = null;
        if (annexType.getEncryptableBinaryContent() != null) {
            annexHandler = annexType.getEncryptableBinaryContent();
        } else if (annexType.getEncryptableTextContent() != null) {
            annexHandler = annexType.getEncryptableTextContent();
        }
        if (annexHandler != null) {
            annex.setContent(this.base64decoding(annexHandler, documentMessage.isEncrypted()));
        }
        documentMessage.getAnnexList().add(annex);
    }

    private void processMainDocument(GetFullMessageResponse response, DocumentMessage<?> documentMessage) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        Document document = new Document();
        document.setFilename(response.getMessage().getContentContext().getContent().getDocument().getDownloadFileName());
        document.setMimeType(response.getMessage().getContentContext().getContent().getDocument().getMimeType());
        document.setTitle(response.getMessage().getContentContext().getContent().getDocument().getTitle());
        DataHandler responseHandler = null;
        if (response.getMessage().getContentContext().getContent().getDocument().getEncryptableBinaryContent() != null) {
            responseHandler = response.getMessage().getContentContext().getContent().getDocument().getEncryptableBinaryContent();
        } else if (response.getMessage().getContentContext().getContent().getDocument().getEncryptableTextContent() != null) {
            responseHandler = response.getMessage().getContentContext().getContent().getDocument().getEncryptableTextContent();
        }
        if (responseHandler != null) {
            try {
                document.setContent(this.base64decoding(responseHandler, documentMessage.isEncrypted()));
            }
            catch (UnsealConnectorException e) {
                document.setException(e);
            }
        }
        documentMessage.setDocument(document);
    }

    private void processINSSPatient(GetFullMessageResponse response, DocumentMessage<?> documentMessage) throws TechnicalConnectorException, EhboxBusinessConnectorException, UnsupportedEncodingException {
        boolean encrypted;
        byte[] patientInss;
        DataHandler encryptableINSSPatient = response.getMessage().getContentContext().getContent().getEncryptableINSSPatient();
        if (encryptableINSSPatient != null && (patientInss = this.base64decoding(encryptableINSSPatient, encrypted = documentMessage.isEncrypted())) != null) {
            documentMessage.setPatientInss(new String(patientInss, Charset.UTF_8.getName()));
            documentMessage.setEncrypted(encrypted);
        }
    }

    private void processFreeText(GetFullMessageResponse response, DocumentMessage<?> documentMessage) throws TechnicalConnectorException, EhboxBusinessConnectorException, UnsupportedEncodingException {
        byte[] freeText;
        if (response.getMessage().getContentContext().getContent().getFreeInformations() != null && (freeText = this.base64decoding(response.getMessage().getContentContext().getContent().getFreeInformations().getEncryptableFreeText(), documentMessage.isEncrypted())) != null) {
            documentMessage.setFreeText(new String(freeText, Charset.UTF_8.getName()));
        }
    }

    protected final Addressee buildAddressee(SenderType sender) {
        IdentifierType identifierType = IdentifierType.lookup((String)sender.getType(), (String)sender.getSubType(), (int)49);
        Addressee destination = new Addressee(identifierType);
        destination.setId(sender.getId());
        if (StringUtils.isEmpty((String)sender.getPersonInOrganisation())) {
            destination.setFirstName(sender.getFirstName());
            destination.setLastName(sender.getName());
        } else {
            destination.setOrganizationName(sender.getName());
            destination.setPersonInOrganisation(sender.getPersonInOrganisation());
        }
        destination.setQuality(sender.getQuality());
        return destination;
    }

    protected final Addressee buildAddressee(EhboxIdentifierType identifier) {
        IdentifierType identifierType = IdentifierType.lookup((String)identifier.getType(), (String)identifier.getSubType(), (int)49);
        Addressee destination = new Addressee(identifierType);
        destination.setId(identifier.getId());
        if (identifier.getUser() != null) {
            destination.setFirstName(identifier.getUser().getFirstName());
            destination.setLastName(identifier.getUser().getLastName());
        }
        destination.setQuality(identifier.getQuality());
        destination.setIdenfitierTypeHelper(IdentifierType.lookup((String)identifier.getType(), (String)identifier.getSubType(), (int)49));
        return destination;
    }

    private byte[] base64decoding(DataHandler dataHandler, boolean encrypted) throws TechnicalConnectorException, EhboxBusinessConnectorException {
        try {
            if (dataHandler == null || dataHandler.getContent() == null) {
                return null;
            }
            byte[] byteVal = this.toBytes(dataHandler);
            return this.base64decoding(byteVal, encrypted);
        }
        catch (IOException e) {
            LOG.debug("\t## IOException occured while decoding base64");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, (Throwable)e, new Object[]{"decoding base64"});
        }
    }

    protected final byte[] base64decoding(byte[] data, boolean encrypted) throws TechnicalConnectorException, EhboxBusinessConnectorException, UnsupportedEncodingException {
        if (data == null || data.length == 0) {
            return new byte[0];
        }
        byte[] byteVal = data;
        String content = new String(byteVal, Charset.UTF_8.getName());
        if (ConfigFactory.getConfigValidator().getBooleanProperty("ehboxv2.try.to.base64decode.content", Boolean.valueOf(true)).booleanValue() && content.matches(BASE64_VALIDATOR_REGEX)) {
            byteVal = Base64.decode((byte[])byteVal);
        }
        LOG.debug(new String(byteVal, Charset.UTF_8.getName()));
        if (encrypted) {
            if (SessionUtil.getEncryptionCrypto() == null) {
                throw new EhboxBusinessConnectorException(EhboxBusinessConnectorExceptionValues.CRYPTO_NOT_PROPERLY_INITIALIZED, (Throwable)null, new Object[0]);
            }
            byteVal = SessionUtil.getEncryptionCrypto().unseal(byteVal);
        }
        LOG.debug(new String(byteVal, Charset.UTF_8.getName()));
        return byteVal;
    }

    private byte[] toBytes(DataHandler dh) throws IOException {
        int bytesRead;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(0x100000);
        InputStream in = dh.getInputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) >= 0) {
            bos.write(buffer, 0, bytesRead);
        }
        return bos.toByteArray();
    }
}

