/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.ehboxV2.builders;

import be.ehealth.businessconnector.ehboxV2.builders.ConsultationMessageBuilder;
import be.ehealth.businessconnector.ehboxV2.builders.SendMessageBuilder;
import be.ehealth.businessconnector.ehboxV2.builders.impl.ConsultationMessageBuilderImpl;
import be.ehealth.businessconnector.ehboxV2.builders.impl.SendMessageBuilderImpl;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;

public final class BuilderFactory
implements SessionServiceWithCache {
    private static SendMessageBuilder sendMessageBuilder;
    private static ConsultationMessageBuilder consultationMessageBuilder;
    private static BuilderFactory instance;

    private BuilderFactory() {
    }

    public static synchronized SendMessageBuilder getSendMessageBuilder() throws TechnicalConnectorException {
        BuilderFactory.initIfNeeded();
        if (sendMessageBuilder == null) {
            sendMessageBuilder = new SendMessageBuilderImpl(KeyDepotManagerFactory.getKeyDepotManager());
        }
        return sendMessageBuilder;
    }

    public static synchronized ConsultationMessageBuilder getConsultationMessageBuilder() throws TechnicalConnectorException {
        BuilderFactory.initIfNeeded();
        if (consultationMessageBuilder == null) {
            consultationMessageBuilder = new ConsultationMessageBuilderImpl();
        }
        return consultationMessageBuilder;
    }

    private static void initIfNeeded() {
        if (instance == null) {
            BuilderFactory.createAndRegisterInstance();
        }
    }

    private static synchronized void createAndRegisterInstance() {
        if (instance == null) {
            instance = new BuilderFactory();
            Session.getInstance().registerSessionService((SessionServiceWithCache)instance);
        }
    }

    public void flushCache() {
        instance = null;
        sendMessageBuilder = null;
        consultationMessageBuilder = null;
    }
}

