/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.dmg.builders.impl;

import be.cin.nip.async.generic.MsgResponse;
import be.ehealth.business.mycarenetcommons.builders.BlobBuilder;
import be.ehealth.business.mycarenetcommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetcommons.domain.Blob;
import be.ehealth.business.mycarenetcommons.exception.InvalidBlobContentConnectorException;
import be.ehealth.business.mycarenetcommons.mapper.SendRequestMapper;
import be.ehealth.businessconnector.dmg.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.dmg.domain.DmgBuilderResponse;
import be.ehealth.businessconnector.dmg.mappers.BlobMapper;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ByteArrayDatasource;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.globalmedicalfile.core.v1.BlobType;
import be.fgov.ehealth.globalmedicalfile.protocol.v1.ConsultGlobalMedicalFileResponse;
import be.fgov.ehealth.globalmedicalfile.protocol.v1.NotifyGlobalMedicalFileResponse;
import be.fgov.ehealth.globalmedicalfile.protocol.v1.SendResponseType;
import be.fgov.ehealth.messageservices.core.v1.RetrieveTransactionResponse;
import be.fgov.ehealth.messageservices.core.v1.SendTransactionResponse;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2005._05.xmlmime.Base64Binary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResponseObjectBuilderImpl
implements ResponseObjectBuilder,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseObjectBuilderImpl.class);

    @Override
    public final DmgBuilderResponse handleSendResponseType(SendResponseType sendResponse) throws TechnicalConnectorException {
        String code = sendResponse.getStatus().getCode();
        BlobType blobType = sendResponse.getReturn().getDetail();
        Blob blob = BlobMapper.mapBlobfromBlobType(blobType);
        Base64Binary xadesT = sendResponse.getReturn().getXadesT();
        return this.createDmgBuilderResponse(code, (Serializable)sendResponse, blob, xadesT);
    }

    private DmgBuilderResponse createDmgBuilderResponse(String code, Serializable originalResult, Blob blob, Base64Binary xadesT) throws TechnicalConnectorException, InvalidBlobContentConnectorException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result.ehealth.status", code);
        result.put("result.original", originalResult);
        BlobBuilder blobBuilder = BlobBuilderFactory.getBlobBuilder((String)"dmg");
        byte[] resultbusiness = null;
        try {
            resultbusiness = blobBuilder.checkAndRetrieveContent(blob);
        }
        catch (InvalidBlobContentConnectorException e) {
            if (e.getDecompressedBlob() != null) {
                LOG.error(e.getMessage());
                resultbusiness = e.getDecompressedBlob();
            }
            throw e;
        }
        if (xadesT == null || xadesT.getValue() == null || org.apache.commons.lang3.ArrayUtils.isEmpty((byte[])xadesT.getValue())) {
            result.put("result.has.signature", false);
        } else {
            result.put("result.has.signature", true);
            byte[] xadesTByteArray = ArrayUtils.clone((byte[])xadesT.getValue());
            SignatureBuilder builder = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES);
            Element sigElement = ConnectorXmlUtils.toElement((byte[])xadesTByteArray);
            HashMap optionMap = new HashMap();
            result.put("result.signature.verification", builder.verify(this.reassemblyMessage(originalResult, sigElement), xadesTByteArray, optionMap));
        }
        result.put("result.business.byte", new ByteArrayDatasource(resultbusiness));
        this.putUnmarshalledMessage(originalResult, result, resultbusiness);
        return new DmgBuilderResponse(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void putUnmarshalledMessage(Object originalResult, Map<String, Object> result, byte[] resultbusiness) throws TechnicalConnectorException {
        if (resultbusiness == null || resultbusiness.length == 0) {
            return;
        }
        if (originalResult instanceof ConsultGlobalMedicalFileResponse) {
            result.put("result.business.RetrieveTransactionResponse", this.unmarshallByteContent(resultbusiness, RetrieveTransactionResponse.class));
            return;
        } else if (originalResult instanceof SendResponseType) {
            result.put("result.business.SendTransactionResponse", this.unmarshallByteContent(resultbusiness, SendTransactionResponse.class));
            return;
        } else {
            if (!(originalResult instanceof MsgResponse)) throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, new Object[]{"Unsupported SendResponseType or MsgResponse type: " + originalResult.getClass()});
            MsgResponse msgResponse = (MsgResponse)originalResult;
            String messageName = msgResponse.getDetail().getMessageName();
            if ("GMD-CONSULT-HCP".equals(messageName)) {
                result.put("result.business.RetrieveTransactionResponse", this.unmarshallByteContent(resultbusiness, RetrieveTransactionResponse.class));
                return;
            } else {
                if (!"GMD-CLOSURE".equals(messageName) && !"GMD-EXTENSION".equals(messageName)) throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, new Object[]{"unsupported messageName for Blob in MsgResponse : messageName=[" + messageName + "]"});
                result.put("result.business.KmehrMessage", this.unmarshallByteContent(resultbusiness, Kmehrmessage.class));
            }
        }
    }

    private <T extends Serializable> Serializable unmarshallByteContent(byte[] byteArray, Class<T> unmarshallClass) {
        MarshallerHelper helper = new MarshallerHelper(unmarshallClass, unmarshallClass);
        Serializable jaxbObject = null;
        try {
            if (byteArray != null && ConfigFactory.getConfigValidator().getBooleanProperty("be.ehealth.businessconnector.dmg.builders.impl.dumpMessages", Boolean.valueOf(false)).booleanValue()) {
                LOG.debug("unmarshallByteContent: unmarshalling following xml : " + new String(byteArray));
            }
            jaxbObject = (Serializable)helper.toObject(byteArray);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to create business object. Reason: IllegalArgumentException: " + e.getMessage());
            return e;
        }
        return jaxbObject;
    }

    @Override
    public DmgBuilderResponse handleAsyncResponse(MsgResponse asyncMsgResponse) throws TechnicalConnectorException {
        String code = "200";
        Blob blob = SendRequestMapper.mapToBlob((be.cin.types.v1.Blob)asyncMsgResponse.getDetail());
        Base64Binary xadesT = asyncMsgResponse.getXadesT();
        return this.createDmgBuilderResponse(code, (Serializable)asyncMsgResponse, blob, xadesT);
    }

    private byte[] reassemblyMessage(Object responseObject, Element sigElement) throws TechnicalConnectorException {
        MarshallerHelper responseMarshaller = this.getMarshallerHelper(responseObject);
        Document explodedDoc = responseMarshaller.toDocument(responseObject);
        explodedDoc.adoptNode(sigElement);
        Element el = explodedDoc.createElement("XadesT-Signature");
        el.appendChild(sigElement);
        ConnectorXmlUtils.getFirstChildElement((Node)explodedDoc).appendChild(el);
        return ConnectorXmlUtils.toByteArray((Node)explodedDoc);
    }

    private <T> MarshallerHelper<T, T> getMarshallerHelper(Object response) throws TechnicalConnectorException {
        MarshallerHelper responseMarshaller = null;
        if (response instanceof ConsultGlobalMedicalFileResponse) {
            responseMarshaller = new MarshallerHelper(ConsultGlobalMedicalFileResponse.class, ConsultGlobalMedicalFileResponse.class);
        } else if (response instanceof NotifyGlobalMedicalFileResponse) {
            responseMarshaller = new MarshallerHelper(NotifyGlobalMedicalFileResponse.class, NotifyGlobalMedicalFileResponse.class);
        } else if (response instanceof MsgResponse) {
            responseMarshaller = new MarshallerHelper(MsgResponse.class, MsgResponse.class);
        } else {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, new Object[]{"Unsupported SendResponseType: " + response.getClass()});
        }
        return responseMarshaller;
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{BlobType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ConsultGlobalMedicalFileResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{NotifyGlobalMedicalFileResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendResponseType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RetrieveTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendTransactionResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Kmehrmessage.class});
    }
}

