/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.dicsv4.session.impl;

import be.ehealth.business.common.helper.EhealthServiceHelper;
import be.ehealth.businessconnector.dicsv4.exception.DicsDataNotFoundException;
import be.ehealth.businessconnector.dicsv4.exception.DicsException;
import be.ehealth.businessconnector.dicsv4.service.ServiceFactory;
import be.ehealth.businessconnector.dicsv4.session.DicsSessionService;
import be.ehealth.businessconnector.dicsv4.validator.DicsValidator;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.SoaErrorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.EhealthReplyValidator;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.fgov.ehealth.commons.protocol.v2.StatusResponseType;
import be.fgov.ehealth.dics.protocol.v4.FindAmpRequest;
import be.fgov.ehealth.dics.protocol.v4.FindAmpResponse;
import be.fgov.ehealth.dics.protocol.v4.FindCommentedClassificationRequest;
import be.fgov.ehealth.dics.protocol.v4.FindCommentedClassificationResponse;
import be.fgov.ehealth.dics.protocol.v4.FindCompanyRequest;
import be.fgov.ehealth.dics.protocol.v4.FindCompanyResponse;
import be.fgov.ehealth.dics.protocol.v4.FindCompoundingFormulaRequest;
import be.fgov.ehealth.dics.protocol.v4.FindCompoundingFormulaResponse;
import be.fgov.ehealth.dics.protocol.v4.FindCompoundingIngredientRequest;
import be.fgov.ehealth.dics.protocol.v4.FindCompoundingIngredientResponse;
import be.fgov.ehealth.dics.protocol.v4.FindLegislationTextRequest;
import be.fgov.ehealth.dics.protocol.v4.FindLegislationTextResponse;
import be.fgov.ehealth.dics.protocol.v4.FindReferencesRequest;
import be.fgov.ehealth.dics.protocol.v4.FindReferencesResponse;
import be.fgov.ehealth.dics.protocol.v4.FindReimbursementRequest;
import be.fgov.ehealth.dics.protocol.v4.FindReimbursementResponse;
import be.fgov.ehealth.dics.protocol.v4.FindVmpGroupRequest;
import be.fgov.ehealth.dics.protocol.v4.FindVmpGroupResponse;
import be.fgov.ehealth.dics.protocol.v4.FindVmpRequest;
import be.fgov.ehealth.dics.protocol.v4.FindVmpResponse;
import be.fgov.ehealth.dics.protocol.v4.FindVtmRequest;
import be.fgov.ehealth.dics.protocol.v4.FindVtmResponse;
import be.fgov.ehealth.dics.protocol.v4.GetListOfActualMedicinalProductPackagesRequest;
import be.fgov.ehealth.dics.protocol.v4.GetListOfActualMedicinalProductPackagesResponse;
import be.fgov.ehealth.dics.protocol.v4.GetListOfActualMedicinalProductsRequest;
import be.fgov.ehealth.dics.protocol.v4.GetListOfActualMedicinalProductsResponse;
import be.fgov.ehealth.dics.protocol.v4.GetListOfVirtualMedicinalProductsRequest;
import be.fgov.ehealth.dics.protocol.v4.GetListOfVirtualMedicinalProductsResponse;
import be.fgov.ehealth.dics.protocol.v4.GetListOfVmpGroupsRequest;
import be.fgov.ehealth.dics.protocol.v4.GetListOfVmpGroupsResponse;
import be.fgov.ehealth.dics.protocol.v4.ListConsultationRequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicsSessionServiceImpl
implements DicsSessionService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private SessionValidator sessionValidator;
    private EhealthReplyValidator replyValidator;
    private DicsValidator dicsValidator;
    private static final Logger LOG = LoggerFactory.getLogger(DicsSessionServiceImpl.class);

    public DicsSessionServiceImpl(SessionValidator sessionValidator, EhealthReplyValidator replyValidator, DicsValidator dicsValidator) throws TechnicalConnectorException {
        this.sessionValidator = sessionValidator;
        this.replyValidator = replyValidator;
        this.dicsValidator = dicsValidator;
        if (!Session.getInstance().hasValidSession()) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_VALID_SESSION, new Object[0]);
        }
    }

    public DicsSessionServiceImpl() {
        LOG.debug("creating DicsSessionServiceImpl for bootstrapping purposes");
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindAmpRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindAmpResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReferencesRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReferencesResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindVmpRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindVmpResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindLegislationTextRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindLegislationTextResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompanyRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompanyResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ListConsultationRequestType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompanyResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompanyRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCompanyResponse.class});
    }

    @Override
    public FindAmpResponse findAmp(FindAmpRequest findAmpRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findAmpRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findAmp", FindAmpResponse.class);
    }

    @Override
    public FindCompanyResponse findCompany(FindCompanyRequest findCompanyRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findCompanyRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findCompany", FindCompanyResponse.class);
    }

    @Override
    public FindLegislationTextResponse findLegislationText(FindLegislationTextRequest findLegislationTextRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findLegislationTextRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findLegislationText", FindLegislationTextResponse.class);
    }

    @Override
    public FindReferencesResponse findReferences(FindReferencesRequest findReferencesRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findReferencesRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findReferences", FindReferencesResponse.class);
    }

    @Override
    public FindReimbursementResponse findReimbursement(FindReimbursementRequest findReimbursementRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findReimbursementRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findReimbursement", FindReimbursementResponse.class);
    }

    @Override
    public FindVmpResponse findVmp(FindVmpRequest findVmpRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findVmpRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findVmpRequest", FindVmpResponse.class);
    }

    @Override
    public FindCommentedClassificationResponse findCommentedClassification(FindCommentedClassificationRequest findCommentedClassificationRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findCommentedClassificationRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findCommentedClassificationRequest", FindCommentedClassificationResponse.class);
    }

    @Override
    public FindCompoundingFormulaResponse findFormula(FindCompoundingFormulaRequest findCompoundingFormulaRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findCompoundingFormulaRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findCommentedClassificationRequest", FindCompoundingFormulaResponse.class);
    }

    @Override
    public FindCompoundingIngredientResponse findIngredient(FindCompoundingIngredientRequest findCompoundingIngredientRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findCompoundingIngredientRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findCommentedClassificationRequest", FindCompoundingIngredientResponse.class);
    }

    @Override
    public FindVmpGroupResponse findVmpGroup(FindVmpGroupRequest findVmpGroupRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findVmpGroupRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findCommentedClassificationRequest", FindVmpGroupResponse.class);
    }

    @Override
    public FindVtmResponse findVtm(FindVtmRequest findVtmRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(findVtmRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findCommentedClassificationRequest", FindVtmResponse.class);
    }

    @Override
    public GetListOfVirtualMedicinalProductsResponse getListOfVirtualMedicinalProducts(GetListOfVirtualMedicinalProductsRequest getListOfVirtualMedicinalProductsRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(getListOfVirtualMedicinalProductsRequest, "urn:be:fgov:ehealth:dics:protocol:v4:getListOfVirtualMedicinalProducts", GetListOfVirtualMedicinalProductsResponse.class);
    }

    @Override
    public GetListOfVmpGroupsResponse getListOfVmpGroups(GetListOfVmpGroupsRequest getListOfVmpGroupsRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(getListOfVmpGroupsRequest, "urn:be:fgov:ehealth:dics:protocol:v4:getListOfVmpGroups", GetListOfVmpGroupsResponse.class);
    }

    @Override
    public GetListOfActualMedicinalProductPackagesResponse getListOfActualMedicinalProductPackages(GetListOfActualMedicinalProductPackagesRequest getListOfActualMedicinalProductPackagesRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(getListOfActualMedicinalProductPackagesRequest, "urn:be:fgov:ehealth:dics:protocol:v4:getListOfActualMedicinalProductPackages", GetListOfActualMedicinalProductPackagesResponse.class);
    }

    @Override
    public GetListOfActualMedicinalProductsResponse getListOfActualMedicinalProducts(GetListOfActualMedicinalProductsRequest getListOfActualMedicinalProductsRequest) throws TechnicalConnectorException, DicsException, DicsDataNotFoundException {
        return this.executeOperation(getListOfActualMedicinalProductsRequest, "urn:be:fgov:ehealth:dics:protocol:v4:findCommentedClassificationRequest", GetListOfActualMedicinalProductsResponse.class);
    }

    private <T extends StatusResponseType> T executeOperation(Object request, String operation, Class<T> clazz) throws DicsException, TechnicalConnectorException, DicsDataNotFoundException {
        try {
            SAMLToken samlToken = Session.getInstance().getSession().getSAMLToken();
            StatusResponseType response = EhealthServiceHelper.callEhealthServiceV2((SAMLToken)samlToken, (GenericRequest)ServiceFactory.getDicsService(samlToken, operation), (Object)request, clazz, (SessionValidator)this.sessionValidator, (EhealthReplyValidator)this.replyValidator);
            this.dicsValidator.validateResponse(response);
            return (T)response;
        }
        catch (SoaErrorException ex) {
            throw new DicsException((StatusResponseType)ex.getResponseTypeV2());
        }
    }
}

