/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.dicsv2.service;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static final String PROP_ENDPOINT_DICS_V2 = "endpoint.dicsv2";
    private static final String PROP_VALIDATION_INCOMING_DICS = "validation.incoming.message.dicsv2";
    public static final String DICS_XSD = "/ehealth-dics/XSD/ehealth-dics-protocol-2_0.xsd";
    private static Configuration config = ConfigFactory.getConfigValidatorFor((String[])new String[]{"endpoint.dicsv2"});

    private ServiceFactory() {
        throw new UnsupportedOperationException("class may not be initialized, only static methods should be used");
    }

    public static GenericRequest getDicsService(SAMLToken token, String soapAction) throws TechnicalConnectorException {
        if (token == null) {
            throw new IllegalArgumentException("getDicsService : missing input parameter token");
        }
        if (soapAction == null) {
            throw new IllegalArgumentException("getDicsService :missing input parameter soapAction");
        }
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_DICS_V2));
        genReq.setSoapAction(soapAction);
        genReq.setCredential((Credential)token, TokenType.X509);
        genReq.setDefaultHandlerChain();
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_DICS))) {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, new String[]{DICS_XSD}));
        } else {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, new String[]{DICS_XSD}));
        }
        genReq.setHandlerChain(chain);
        return genReq;
    }
}

