/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.dics.session.impl;

import be.ehealth.businessconnector.dics.service.ServiceFactory;
import be.ehealth.businessconnector.dics.session.DicsSessionService;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.fgov.ehealth.dics.protocol.v1.FindCNKRequest;
import be.fgov.ehealth.dics.protocol.v1.FindCNKResponse;
import be.fgov.ehealth.dics.protocol.v1.FindParagraphRequest;
import be.fgov.ehealth.dics.protocol.v1.FindParagraphResponse;
import be.fgov.ehealth.dics.protocol.v1.FindParagraphTextRequest;
import be.fgov.ehealth.dics.protocol.v1.FindParagraphTextResponse;
import be.fgov.ehealth.dics.protocol.v1.FindReimbursementConditionsRequest;
import be.fgov.ehealth.dics.protocol.v1.FindReimbursementConditionsResponse;
import be.fgov.ehealth.dics.protocol.v1.GetAddedDocumentsRequest;
import be.fgov.ehealth.dics.protocol.v1.GetAddedDocumentsResponse;
import be.fgov.ehealth.dics.protocol.v1.GetParagraphExclusionsRequest;
import be.fgov.ehealth.dics.protocol.v1.GetParagraphExclusionsResponse;
import be.fgov.ehealth.dics.protocol.v1.GetParagraphIncludedSpecialtiesRequest;
import be.fgov.ehealth.dics.protocol.v1.GetParagraphIncludedSpecialtiesResponse;
import be.fgov.ehealth.dics.protocol.v1.GetProfessionalAuthorizationsRequest;
import be.fgov.ehealth.dics.protocol.v1.GetProfessionalAuthorizationsResponse;
import javax.xml.soap.SOAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicsSessionServiceImpl
implements DicsSessionService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private SessionValidator sessionValidator;
    private static final Logger LOG = LoggerFactory.getLogger(DicsSessionServiceImpl.class);

    public DicsSessionServiceImpl(SessionValidator sessionValidator) throws TechnicalConnectorException {
        this.sessionValidator = sessionValidator;
        if (!Session.getInstance().hasValidSession()) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_VALID_SESSION, new Object[0]);
        }
    }

    public DicsSessionServiceImpl() {
        LOG.debug("creating DicsSessionServiceImpl for bootstrapping purposes");
    }

    @Override
    public FindParagraphTextResponse findParagraphText(FindParagraphTextRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v1:findParagraphText", FindParagraphTextResponse.class);
    }

    @Override
    public GetParagraphExclusionsResponse getParagraphExclusions(GetParagraphExclusionsRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v1:getParagraphExclusions", GetParagraphExclusionsResponse.class);
    }

    @Override
    public GetParagraphIncludedSpecialtiesResponse getParagraphIncludedSpecialities(GetParagraphIncludedSpecialtiesRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v1:getParagraphIncludedSpecialities", GetParagraphIncludedSpecialtiesResponse.class);
    }

    @Override
    public GetProfessionalAuthorizationsResponse getProfessionalAuthorizations(GetProfessionalAuthorizationsRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v1:getProfessionalAuthorizations", GetProfessionalAuthorizationsResponse.class);
    }

    @Override
    public GetAddedDocumentsResponse getAddedDocuments(GetAddedDocumentsRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v1:getAddedDocuments", GetAddedDocumentsResponse.class);
    }

    @Override
    public FindReimbursementConditionsResponse findReimbursementConditions(FindReimbursementConditionsRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v1:findReimbursementConditions", FindReimbursementConditionsResponse.class);
    }

    @Override
    public FindParagraphResponse findParagraph(FindParagraphRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v1:findParagraph", FindParagraphResponse.class);
    }

    @Override
    public FindCNKResponse findCNK(FindCNKRequest request) throws TechnicalConnectorException {
        return this.executeOperation(request, "urn:be:fgov:ehealth:dics:protocol:v1:findCNK", FindCNKResponse.class);
    }

    private <T> T executeOperation(Object request, String operation, Class<T> clazz) throws TechnicalConnectorException {
        try {
            this.sessionValidator.validateSession();
            GenericRequest service = ServiceFactory.getDicsService(Session.getInstance().getSession().getSAMLToken(), operation);
            service.setPayload(request);
            return (T)be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service).asObject(clazz);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCNKRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindCNKResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphTextRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindParagraphTextResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementConditionsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{FindReimbursementConditionsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAddedDocumentsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetAddedDocumentsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphExclusionsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphExclusionsResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphIncludedSpecialtiesRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetParagraphIncludedSpecialtiesResponse.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetProfessionalAuthorizationsRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{GetProfessionalAuthorizationsResponse.class});
    }
}

