/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.civics.service;

import be.ehealth.businessconnector.civics.exception.CivicsBusinessConnectorException;
import be.ehealth.businessconnector.civics.service.SamCivicsService;
import be.ehealth.businessconnector.civics.service.impl.SamCivicsServiceImpl;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import java.net.MalformedURLException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static final String PROP_ENDPOINT_CIVICS = "endpoint.civics";
    private static final String PROP_VALIDATION_INCOMING_CIVICS = "validation.incoming.civics.message";
    private static List<String> expectedProps = new ArrayList<String>();
    private static Configuration config;
    private static final String CIVICS_PROT = "/XSD/civics_v1/sam-civics-protocol.xsd";
    protected static final String[] CIVICS_XSD;

    private ServiceFactory() {
    }

    public static GenericRequest getSamCivicsPort(X509Certificate certificate, PrivateKey privateKey) throws MalformedURLException, TechnicalConnectorException, CivicsBusinessConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_CIVICS));
        genReq.setCertificateSecured(certificate, privateKey);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_CIVICS))) {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, CIVICS_XSD));
        } else {
            chain.registerHandler(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, CIVICS_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    public static SamCivicsService getSamCivicsService(SessionValidator sessionValidator) {
        return new SamCivicsServiceImpl(sessionValidator);
    }

    static {
        CIVICS_XSD = new String[]{CIVICS_PROT};
        expectedProps.add(PROP_ENDPOINT_CIVICS);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

