/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.chapterIV.utils;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.utils.IdentifierType;
import java.util.ArrayList;

public final class KeyDepotHelper {
    private static final String CH4_IDENTIFIER_TYPE_PROPERTY = "chapterIV.keydepot.identifiertype";
    private static final String CH4_IDENTIFIER_SUBTYPE_PROPERTY = "chapterIV.keydepot.identifiersubtype";
    private static final String CH4_IDENTIFIER_VALUE_PROPERTY = "chapterIV.keydepot.identifiervalue";
    private static final String CH4_APPLICATION_PROPERTY = "chapterIV.keydepot.application";
    private static ConfigValidator configValidator;

    private KeyDepotHelper() {
    }

    public static EncryptionToken getChapterIVEncryptionToken() throws TechnicalConnectorException {
        String identifierTypeString = configValidator.getProperty(CH4_IDENTIFIER_TYPE_PROPERTY);
        String identifierSubTypeString = configValidator.getProperty(CH4_IDENTIFIER_SUBTYPE_PROPERTY);
        int identifierSource = 48;
        IdentifierType identifier = IdentifierType.lookup((String)identifierTypeString, null, (int)identifierSource);
        if (identifier == null) {
            throw new IllegalStateException("invalid configuration : identifier with type ]" + identifierTypeString + "[ and subtype ]" + identifierSubTypeString + "[ for source ETKDEPOT not found");
        }
        return KeyDepotManagerFactory.getKeyDepotManager().getETK(identifier, configValidator.getLongProperty(CH4_IDENTIFIER_VALUE_PROPERTY, Long.valueOf(0L)), configValidator.getProperty(CH4_APPLICATION_PROPERTY));
    }

    static {
        ArrayList<String> neededProperties = new ArrayList<String>();
        neededProperties.add(CH4_APPLICATION_PROPERTY);
        neededProperties.add(CH4_IDENTIFIER_TYPE_PROPERTY);
        neededProperties.add(CH4_IDENTIFIER_SUBTYPE_PROPERTY);
        neededProperties.add(CH4_IDENTIFIER_VALUE_PROPERTY);
        configValidator = ConfigFactory.getConfigValidator(neededProperties);
    }
}

