/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.chapterIV.builders.impl;

import be.cin.types.v1.CareReceiverIdType;
import be.ehealth.business.mycarenetcommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetcommons.domain.CommonInput;
import be.ehealth.business.mycarenetcommons.domain.McnPackageInfo;
import be.ehealth.business.mycarenetcommons.util.McnConfigUtil;
import be.ehealth.businessconnector.chapterIV.builders.CommonBuilder;
import be.ehealth.businessconnector.chapterIV.builders.KmehrBuilder;
import be.ehealth.businessconnector.chapterIV.domain.ChapterIVBuilderResponse;
import be.ehealth.businessconnector.chapterIV.domain.ChapterIVReferences;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorException;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.chapterIV.mappers.CommonInputMapper;
import be.ehealth.businessconnector.chapterIV.utils.ACLUtils;
import be.ehealth.businessconnector.chapterIV.utils.KeyDepotHelper;
import be.ehealth.businessconnector.chapterIV.validators.Chapter4XmlValidator;
import be.ehealth.businessconnector.chapterIV.validators.KmehrValidator;
import be.ehealth.businessconnector.chapterIV.wrapper.Chap4MedicalAdvisorAgreementRequestWrapper;
import be.ehealth.businessconnector.chapterIV.wrapper.SealedRequestWrapper;
import be.ehealth.businessconnector.chapterIV.wrapper.UnsealedRequestWrapper;
import be.ehealth.businessconnector.chapterIV.wrapper.factory.XmlObjectFactory;
import be.ehealth.businessconnector.chapterIV.wrapper.impl.WrappedObjectMarshallerHelper;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManager;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.service.kgss.KgssManager;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.chap4.core.v1.CommonInputType;
import be.fgov.ehealth.chap4.core.v1.RecordCommonInputType;
import be.fgov.ehealth.chap4.core.v1.SecuredContentType;
import be.fgov.ehealth.etee.kgss._1_0.protocol.CredentialType;
import be.fgov.ehealth.medicalagreement.core.v1.Kmehrrequest;
import be.fgov.ehealth.standards.kmehr.id.v1.IDINSURANCEschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENT;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENTschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.standards.kmehr.schema.v1.MemberinsuranceType;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CommonBuilderImpl
implements CommonBuilder,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    public static final String RESULT = "result";
    public static final String RESULT_SEALEDREQUEST = "sealedrequest";
    public static final String RESULT_COMMONINPUT = "commoninput";
    public static final String RESULT_RECORDCOMMONINPUT = "recordcommoninput";
    public static final String RESULT_CARERECEIVER = "carereceiver";
    public static final String RESULT_KMEHRMESSAGE = "kmehrmessage";
    public static final String RESULT_FOLDER = "folder";
    public static final String RESULT_REFERENCES = "references";
    private static final Logger LOG = LoggerFactory.getLogger(CommonBuilderImpl.class);
    private Chapter4XmlValidator chapter4XmlValidator;
    private KmehrBuilder kmehrBuilder;
    private KmehrValidator kmehrValidator;

    @Deprecated
    public CommonBuilderImpl(Crypto crypto, Chapter4XmlValidator chapter4XmlValidator, KmehrValidator kmehrValidator, KmehrBuilder kmehrBuilder) throws TechnicalConnectorException {
        this(chapter4XmlValidator, kmehrValidator, kmehrBuilder);
    }

    public CommonBuilderImpl() {
        LOG.debug("constructor needed for ModuleBootstrapHook");
    }

    public CommonBuilderImpl(Chapter4XmlValidator chapter4XmlValidator, KmehrValidator kmehrValidator, KmehrBuilder kmehrBuilder) throws TechnicalConnectorException {
        this.chapter4XmlValidator = chapter4XmlValidator;
        this.kmehrValidator = kmehrValidator;
        this.kmehrBuilder = kmehrBuilder;
    }

    @Override
    public ChapterIVBuilderResponse createAgreementRequest(FolderType folder, boolean isTest, ChapterIVReferences references, XmlObjectFactory xmlObjectFactory, DateTime agreementStartDate) throws TechnicalConnectorException, ChapterIVBusinessConnectorException {
        if (agreementStartDate == null) {
            throw new ChapterIVBusinessConnectorException(ChapterIVBusinessConnectorExceptionValues.INPUT_PARAM_NULL, "input parameter agreementStartDate was null");
        }
        this.chapter4XmlValidator.validate(folder);
        Kmehrmessage message = this.generateKmehrMessage(folder, references.getKmehrIdSuffix());
        be.fgov.ehealth.chap4.core.v1.CareReceiverIdType careReceiver = this.createCareReceiver(message);
        RecordCommonInputType recordCommonInput = this.createRecordCommonInput(references.getRecordCommonInputId());
        CommonInputType commonInput = this.createCommonInput(isTest, references.getCommonReference(), references.getCommonNIPReference());
        SealedRequestWrapper sealedRequest = this.createAndValidateSealedRequest(message, careReceiver, xmlObjectFactory, agreementStartDate);
        Chap4MedicalAdvisorAgreementRequestWrapper resultWrapper = this.buildAndValidateAgreementRequest(xmlObjectFactory, careReceiver, recordCommonInput, commonInput, sealedRequest);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put(RESULT_REFERENCES, references);
        result.put(RESULT_FOLDER, (Serializable)folder);
        result.put(RESULT_KMEHRMESSAGE, (Serializable)message);
        result.put(RESULT_CARERECEIVER, (Serializable)careReceiver);
        result.put(RESULT_RECORDCOMMONINPUT, (Serializable)recordCommonInput);
        result.put(RESULT_COMMONINPUT, (Serializable)commonInput);
        result.put(RESULT_SEALEDREQUEST, sealedRequest);
        result.put(RESULT, resultWrapper);
        return new ChapterIVBuilderResponse(result);
    }

    private Chap4MedicalAdvisorAgreementRequestWrapper buildAndValidateAgreementRequest(XmlObjectFactory xmlObjectFactory, be.fgov.ehealth.chap4.core.v1.CareReceiverIdType careReceiver, RecordCommonInputType recordCommonInput, CommonInputType commonInput, SealedRequestWrapper sealedRequest) throws TechnicalConnectorException, ChapterIVBusinessConnectorException {
        Chap4MedicalAdvisorAgreementRequestWrapper agreementRequest = xmlObjectFactory.createChap4MedicalAdvisorAgreementRequest();
        agreementRequest.setCareReceiver(careReceiver);
        agreementRequest.setRecordCommonInput(recordCommonInput);
        agreementRequest.setCommonInput(commonInput);
        agreementRequest.setRequest(this.marshallAndEncryptSealedRequest(sealedRequest));
        this.chapter4XmlValidator.validate(agreementRequest.getXmlObject());
        return agreementRequest;
    }

    private Kmehrmessage generateKmehrMessage(FolderType folder, String generatedKmehrIdSuffix) throws TechnicalConnectorException, ChapterIVBusinessConnectorException {
        Kmehrmessage message = new Kmehrmessage();
        message.setHeader(this.kmehrBuilder.generateHeader(generatedKmehrIdSuffix));
        message.getFolders().add(folder);
        this.kmehrValidator.validateKmehrMessage(message);
        return message;
    }

    protected KeyResult getUnknownKey(String subTypeName) throws TechnicalConnectorException {
        List<CredentialType> acl = ACLUtils.createAclChapterIV(subTypeName);
        if (KeyDepotManagerFactory.getKeyDepotManager().getETK(KeyDepotManager.EncryptionTokenType.ENCRYPTION) == null) {
            LOG.debug("\t## EncryptionETK is null");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND, new Object[]{"EncryptionETK is undefined"});
        }
        byte[] systemETK = KeyDepotManagerFactory.getKeyDepotManager().getETK(KeyDepotManager.EncryptionTokenType.ENCRYPTION).getEtk().getEncoded();
        KeyResult unknownKey = KgssManager.getInstance().getNewKeyFromKgss(acl, systemETK);
        return unknownKey;
    }

    protected final RecordCommonInputType createRecordCommonInput(String inputReference) throws ChapterIVBusinessConnectorException {
        if (inputReference == null) {
            throw new ChapterIVBusinessConnectorException(ChapterIVBusinessConnectorExceptionValues.INPUT_PARAM_NULL, "inputReference");
        }
        RecordCommonInputType recordCommonInput = new RecordCommonInputType();
        recordCommonInput.setInputReference(new BigDecimal(inputReference));
        return recordCommonInput;
    }

    protected final CommonInputType createCommonInput(boolean isTest, String commonReference, String commonNIPReference) throws ChapterIVBusinessConnectorException, TechnicalConnectorException {
        McnPackageInfo packageInfo = McnConfigUtil.retrievePackageInfo((String)"chapterIV");
        CommonInput commonInput = RequestBuilderFactory.getCommonBuilder((String)"chapterIV").createCommonInput(packageInfo, isTest, commonReference);
        return CommonInputMapper.mapCommonInputType(commonInput);
    }

    protected final be.fgov.ehealth.chap4.core.v1.CareReceiverIdType createCareReceiver(Kmehrmessage message) {
        be.fgov.ehealth.chap4.core.v1.CareReceiverIdType careReceiver = new be.fgov.ehealth.chap4.core.v1.CareReceiverIdType();
        List patientIds = ((FolderType)message.getFolders().get(0)).getPatient().getIds();
        this.addSsinToCareReceiver(careReceiver, patientIds);
        MemberinsuranceType insurancymembership = ((FolderType)message.getFolders().get(0)).getPatient().getInsurancymembership();
        if (insurancymembership != null) {
            this.addMutualityToCareReceiver(careReceiver, insurancymembership);
            this.addRegNrWithMutToCareReceiver(careReceiver, insurancymembership);
        }
        return careReceiver;
    }

    private void addRegNrWithMutToCareReceiver(be.fgov.ehealth.chap4.core.v1.CareReceiverIdType careReceiver, MemberinsuranceType insurancymembership) {
        Object obj;
        if (insurancymembership.getMembership() != null && (obj = insurancymembership.getMembership()) instanceof Element) {
            Element el = (Element)obj;
            careReceiver.setRegNrWithMut(el.getTextContent());
        }
    }

    private void addMutualityToCareReceiver(be.fgov.ehealth.chap4.core.v1.CareReceiverIdType careReceiver, MemberinsuranceType insurancymembership) {
        if (this.hasIdOfTypeIdInsurance(insurancymembership)) {
            careReceiver.setMutuality(insurancymembership.getId().getValue());
        }
    }

    private boolean hasIdOfTypeIdInsurance(MemberinsuranceType insurancymembership) {
        return insurancymembership.getId() != null && insurancymembership.getId().getS().compareTo((Enum)IDINSURANCEschemes.ID_INSURANCE) == 0;
    }

    private void addSsinToCareReceiver(be.fgov.ehealth.chap4.core.v1.CareReceiverIdType careReceiver, List<IDPATIENT> patientIds) {
        for (IDPATIENT idpatient : patientIds) {
            if (!this.itsAFilledPatientId(idpatient)) continue;
            careReceiver.setSsin(idpatient.getValue());
        }
    }

    private boolean itsAFilledPatientId(IDPATIENT idpatient) {
        return idpatient.getS().compareTo((Enum)IDPATIENTschemes.ID_PATIENT) == 0 && idpatient.getValue() != null && !idpatient.getValue().isEmpty();
    }

    private SecuredContentType marshallAndEncryptSealedRequest(SealedRequestWrapper request) throws TechnicalConnectorException {
        byte[] marshalledContent = WrappedObjectMarshallerHelper.toXMLByteArray(request);
        if (marshalledContent != null) {
            LOG.debug("securedContent : " + new String(marshalledContent));
        }
        byte[] sealedKnown = SessionUtil.getEncryptionCrypto().seal(Crypto.SigningPolicySelector.WITH_NON_REPUDIATION, KeyDepotHelper.getChapterIVEncryptionToken(), marshalledContent);
        SecuredContentType securedContent = new SecuredContentType();
        securedContent.setSecuredContent(sealedKnown);
        return securedContent;
    }

    private SealedRequestWrapper createAndValidateSealedRequest(Kmehrmessage message, be.fgov.ehealth.chap4.core.v1.CareReceiverIdType careReceiver, XmlObjectFactory xmlObjectFactory, DateTime agreementStartDate) throws TechnicalConnectorException, ChapterIVBusinessConnectorException {
        try {
            KeyResult unknownKey = this.getUnknownKey(xmlObjectFactory.getSubtypeNameToRetrieveCredentialTypeProperties());
            SealedRequestWrapper request = xmlObjectFactory.createSealedRequest();
            request.setAgreementStartDate(agreementStartDate);
            request.setCareReceiver(this.mapToCinCareReceiverIdType(careReceiver));
            request.setSealedContent(this.getSealedContent(message, unknownKey, xmlObjectFactory));
            request.setUnsealKeyId(unknownKey.getKeyId());
            this.chapter4XmlValidator.validate(request.getXmlObject());
            return request;
        }
        catch (UnsupportedEncodingException e) {
            LOG.debug("\t## The Character Encoding is not supported : throwing technical connector exception");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CHARACTER_ENCODING_NOTSUPPORTED, (Throwable)e, new Object[0]);
        }
    }

    private CareReceiverIdType mapToCinCareReceiverIdType(be.fgov.ehealth.chap4.core.v1.CareReceiverIdType careReceiver) {
        CareReceiverIdType mappedCareReceiver = new CareReceiverIdType();
        mappedCareReceiver.setMutuality(careReceiver.getMutuality());
        mappedCareReceiver.setRegNrWithMut(careReceiver.getRegNrWithMut());
        mappedCareReceiver.setSsin(careReceiver.getSsin());
        return mappedCareReceiver;
    }

    protected byte[] getSealedContent(Kmehrmessage message, KeyResult unknownKey, XmlObjectFactory xmlObjectFactory) throws UnsupportedEncodingException, TechnicalConnectorException, ChapterIVBusinessConnectorException {
        UnsealedRequestWrapper request = this.createAndValidateUnsealedRequest(message, xmlObjectFactory);
        return SessionUtil.getEncryptionCrypto().seal(Crypto.SigningPolicySelector.WITH_NON_REPUDIATION, unknownKey, WrappedObjectMarshallerHelper.toXMLByteArray(request));
    }

    private UnsealedRequestWrapper createAndValidateUnsealedRequest(Kmehrmessage message, XmlObjectFactory xmlObjectFactory) throws ChapterIVBusinessConnectorException, TechnicalConnectorException {
        UnsealedRequestWrapper request = xmlObjectFactory.createUnsealedRequest();
        request.setEtkHcp(KeyDepotManagerFactory.getKeyDepotManager().getETK(KeyDepotManager.EncryptionTokenType.ENCRYPTION).getEtk().getEncoded());
        request.setKmehrRequest(this.createAndValidateKmehrRequestXmlByteArray(message));
        this.chapter4XmlValidator.validate(request.getXmlObject());
        return request;
    }

    private byte[] createAndValidateKmehrRequestXmlByteArray(Kmehrmessage message) throws TechnicalConnectorException, ChapterIVBusinessConnectorException {
        Kmehrrequest kmehrrequest = this.createKmehrRequest(message);
        this.chapter4XmlValidator.validate(kmehrrequest);
        MarshallerHelper kmehrMarshallHelper = new MarshallerHelper(Kmehrrequest.class, Kmehrrequest.class);
        return kmehrMarshallHelper.toXMLByteArray((Object)kmehrrequest);
    }

    private Kmehrrequest createKmehrRequest(Kmehrmessage message) throws ChapterIVBusinessConnectorException {
        Kmehrrequest kmehrrequest = new Kmehrrequest();
        kmehrrequest.setKmehrmessage(message);
        return kmehrrequest;
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Kmehrmessage.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{Kmehrrequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{CommonInputType.class});
    }
}

